***************************
*** After the Uprisings ***
***************************

use "Arab Barometer IRT.dta", clear


reg irtsupport wave if country==1
estimates store Algeria
reg irtsupport wave if country==5
estimates store Egypt
reg irtsupport wave if country==7
estimates store Iraq
reg irtsupport wave if country==8
estimates store Jordan
reg irtsupport wave if country==10
estimates store Lebanon
reg irtsupport wave if country==15
estimates store Palestine
reg irtsupport wave if country==19
estimates store Sudan
reg irtsupport wave if country==21
estimates store Tunisia
reg irtsupport wave if country==22
estimates store Yemen
reg irtsupport wave
estimates store All

grstyle init
grstyle set imesh, compact

graph set window fontface "Garamond"

coefplot (Algeria, mlabels2(wave=5 "Algeria*")) ///
		(Egypt, mlabels2(wave=5 "Egypt*")) ///
		(Iraq, mlabels2(wave=5 "Iraq")) ///
		(Jordan, mlabels2(wave=5 "Jordan")) ///
		(Lebanon, mlabels2(wave=5 "Lebanon")) ///
		(Palestine, mlabels2(wave=5 "Palestine*")) ///
		(Sudan, mlabels2(wave=5 "Sudan*")) ///
		(Tunisia, mlabels2(wave=5 "Tunisia*")) ///
		(Yemen, mlabels2(wave=5 "Yemen*")) ///
		(All, mlabels2(wave=5 "Overall")), ///
		vertical drop(_cons) ytitle(Change in Support for Democracy, tstyle(size(medsmall))) yline(0, lpattern(dash)) legend(off) ///
		coeflabel(wave = " ") graphregion(color(white)) bgcolor(white) ///
		mcolor(black) mlabcolor(black) ///
		ciopts(lcolor(black))
		
graph export Figure1.png, width(1000) replace

estimates clear
graph set window fontface default
